<?php

/*	Fix zlib WordPress Problems - Details: http://core.trac.wordpress.org/ticket/22430
	================================================= */
	remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );

/*	Definitions
	================================================= */
	define('THEMENAME', 'Equestrian');
	define('THEMEPREFIX', 'eque');

/*	Content Width
	================================================= */	
	if ( ! isset( $content_width ) )
		$content_width = 670;

/*	Load Equestrian Options Panel
	================================================= */	
	require_once(TEMPLATEPATH . '/admin/admin-functions.php');
	require_once(TEMPLATEPATH . '/admin/admin-interface.php');
	require_once(TEMPLATEPATH . '/admin/theme-settings.php');

/*	Load Plugins
	================================================= */
	require_once('plugins/tgm-plugin-activation/class-tgm-plugin-activation.php');
	require_once('plugins/widgets/recent.php');
	require_once('plugins/widgets/search.php');
	
	/* Meta Boxes */
	if (get_option(THEMEPREFIX.'_seo') != "true")	require_once('plugins/meta-boxes/seo.php');
	require_once('plugins/meta-boxes/sliders.php');
	require_once('plugins/meta-boxes/meta-boxes.php');
	function cmb_initialize_cmb_meta_boxes() {
		if ( ! class_exists( 'cmb_Meta_Box' ) ) require_once 'plugins/meta-boxes/init.php';
	}
	
	function register_required_plugins() {
	
		$plugins = array(
			
			// This is an example of how to include a plugin pre-packaged with a theme
			array(
				'name'     				=> 'Layer Slider', // The plugin name
				'slug'     				=> 'LayerSlider', // The plugin slug (typically the folder name)
				'source'   				=> get_stylesheet_directory() . '/plugins/layersliderwp.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Sidebar Generator', // The plugin name
				'slug'     				=> 'sidebars', // The plugin slug (typically the folder name)
				'source'   				=> get_stylesheet_directory() . '/plugins/sidebars.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'SEO Panel Extended', // The plugin name
				'slug'     				=> 'seo-panel-extended', // The plugin slug (typically the folder name)
				'source'   				=> get_stylesheet_directory() . '/plugins/seo-panel-extended.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Envato WordPress Toolkit', // The plugin name
				'slug'     				=> 'envato-wordpress-toolkit-master', // The plugin slug (typically the folder name)
				'source'   				=> get_stylesheet_directory() . '/plugins/envato-wordpress-toolkit-master.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Simple Weather', // The plugin name
				'slug'     				=> 'simple-weather', // The plugin slug (typically the folder name)
				'source'   				=> get_stylesheet_directory() . '/plugins/simple-weather.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     				=> 'Simple QR Codes', // The plugin name
				'slug'     				=> 'simple-qr', // The plugin slug (typically the folder name)
				'source'   				=> get_stylesheet_directory() . '/plugins/simple-qr.zip', // The plugin source
				'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
				'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
			),
			array(
			    'name'      => 'Latest Tweets',
			    'slug'      => 'latest-tweets-widget',
			    'required'  => true
			),
			array(
			    'name'      => 'MailChimp',
			    'slug'      => 'mailchimp',
			    'required'  => true
			),
	
		);
		
		$config = array(
			'domain'       		=> 'CURLYTHEME',         	// Text domain - likely want to be the same as your theme.
			'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
			'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
			'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
			'menu'         		=> 'install-required-plugins', 	// Menu slug
			'has_notices'      	=> true,                       	// Show admin notices or not
			'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
			'message' 			=> '',							// Message to output right before the plugins table
			'strings'      		=> array(
				'page_title'                       			=> __( 'Install Required Plugins', 'CURLYTHEME'),
				'menu_title'                       			=> __( 'Install Plugins', 'CURLYTHEME'),
				'installing'                       			=> __( 'Installing Plugin: %s', 'CURLYTHEME'), // %1$s = plugin name
				'oops'                             			=> __( 'Something went wrong with the plugin API.', 'CURLYTHEME'),
				'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
				'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
				'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
				'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
				'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
				'return'                           			=> __( 'Return to Required Plugins Installer', 'CURLYTHEME'),
				'plugin_activated'                 			=> __( 'Plugin activated successfully.', 'CURLYTHEME'),
				'complete' 									=> __( 'All plugins installed and activated successfully. %s', 'CURLYTHEME'), // %1$s = dashboard link
				'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
			)
		);
	
		tgmpa( $plugins, $config );
	
	}
	add_action( 'tgmpa_register', 'register_required_plugins' );
	
/*  Shortcodes
	================================================= */
	include ('shortcodes/columns.php');	
	include ('shortcodes/dividers.php');
	include ('shortcodes/buttons.php');	
	include ('shortcodes/alert.php');	
	include ('shortcodes/quotes.php');	
	include ('shortcodes/lists.php');
	include ('shortcodes/abbr.php');
	include ('shortcodes/dropcap.php');	
	include ('shortcodes/highlight.php');
	include ('shortcodes/action.php');	
	include ('shortcodes/tabs.php');				
	include ('shortcodes/toggle-box.php');			
	include ('shortcodes/accordion.php'); 			
	include ('shortcodes/youtube.php');	
	include ('shortcodes/vimeo.php');	
	include ('shortcodes/boxes.php');
	include ('shortcodes/marker.php');
	include ('shortcodes/testimonials.php');	
	include ('shortcodes/slider.php');
	include ('shortcodes/person.php');	
	include ('shortcodes/clear.php');	
	include ('shortcodes/progress.php');	
	include ('shortcodes/icon.php');	
	include ('shortcodes/client-list.php');	
	include ('shortcodes/pretty-photo.php');			
	include ('shortcodes/agenda.php');	
	include ('shortcodes/pricing.php');		
	include ('shortcodes/map-maker.php');
	include ('shortcodes/picture-zoom.php');
	include ('shortcodes/full-width.php');
	include ('shortcodes/slider-ios.php');
	include ('shortcodes/slider-roundabout.php');
	include ('shortcodes/photo-frame.php');
	include ('shortcodes/countdown.php');

/*	Add Theme Support & Filters
	================================================= */	
	add_theme_support('post-thumbnails', array('post'));	
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-background' );
	$defaults_header = array(
		'random-default'         => true,
		'width'                  => 1600,
		'height'                 => 500,
		'header-text'            => false,
		'uploads'                => true
	);
	add_theme_support( 'custom-header', $defaults_header );
	add_filter('widget_text', 'do_shortcode');

/*	Load Scripts & Styles
	================================================= */	
	function curly_load_my_scripts(){
		if (!is_admin()) {
		
			// Register Scripts	
			wp_register_script('carousel', get_template_directory_uri() . '/js/jquery.carouFredSel-6.2.1-packed.js', null, true);
			wp_register_script('fitvid', get_template_directory_uri() . '/js/jquery.fitvids.js', null, true);
			wp_register_script('picture-zoom', get_template_directory_uri() . '/js/jquery.zoom-min.js', null, true);
			wp_register_script('google-maps', 'http://maps.googleapis.com/maps/api/js?sensor=false', null, null, true);
			wp_register_script('map-maker', get_template_directory_uri() . '/js/mapmarker.jquery.js', null, null, true);
			wp_register_script('roundabout', get_template_directory_uri() . '/js/jquery.roundabout.min.js', 'jquery', null, true); 
			wp_register_script('easing', get_template_directory_uri() . '/js/jquery.easing.1.3.js', 'jquery', null);
			wp_register_script('drag', get_template_directory_uri() . '/js/jquery.event.drag-2.2.js', 'jquery', null, true); 
			wp_register_script('drop', get_template_directory_uri() . '/js/jquery.event.drop-2.2.js', 'jquery', null, true); 
			wp_register_script('ios', get_template_directory_uri() . '/js/jquery.iosslider.min.js', 'jquery', null, true);
			wp_register_script('countdown', get_template_directory_uri() . '/js/jquery.countdown.min.js', 'jquery', null, true); 
			
			// Register Styles
			wp_register_style( 'bootstrap-css', get_template_directory_uri() . '/css/bootstrap.min.css', null, null, 'all'); 
			wp_register_style( 'fontawesome', '//netdna.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.css', null, null, 'all');
			wp_register_style( 'flip', get_template_directory_uri() . '/css/flip.css', null, null, 'all');
			wp_register_style( 'lightbox-css', get_template_directory_uri() . '/css/lightbox.css', null, null, 'all');
			wp_register_style( 'ios-slider', get_template_directory_uri() . '/css/slider-ios.css', null, null, 'all');
			wp_register_style( 'animate', get_template_directory_uri() . '/css/animate.min.css', null, null, 'all');
			wp_register_style( 'style', get_template_directory_uri() . '/style.css', null, null, 'all');
			wp_register_style( 'ie8fixes', get_template_directory_uri() . '/css/ie-fix.css', null, null, 'all');
		
			// Enqueue Scripts
			wp_enqueue_script('jquery', '/wp-includes/js/jquery/jquery.js', '', '', true);  
			wp_enqueue_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', 'jquery', null, true);
			wp_enqueue_script('dropdown', get_template_directory_uri() . '/js/dropdown-menu.min.js', 'jquery', null, true);
			wp_enqueue_script('lightbox', get_template_directory_uri() . '/js/lightbox-2.6.min.js', 'jquery',  null, true);
			wp_enqueue_script('equalize', get_template_directory_uri() . '/js/equalize.min.js', 'jquery', null, true);
			wp_enqueue_script('hoverint', get_template_directory_uri() . '/js/jquery.hoverIntent.minified.js', 'jquery', null, true);
			wp_enqueue_script('waypoints', get_template_directory_uri() . '/js/waypoints.min.js', 'jquery', null, true);
			wp_enqueue_script('dynamic-js', get_template_directory_uri() . '/js/dynamic-js.php', 'jquery', null, true);
			wp_enqueue_script('main', get_template_directory_uri() . '/js/main.js', 'jquery', null, true);

			
			// Enqueue Styles
			wp_enqueue_style('bootstrap-css');
			wp_enqueue_style('fontawesome');
			wp_enqueue_style('lightbox-css');
			wp_enqueue_style('vertical-slider');
			wp_enqueue_style('ios-slider');
			wp_enqueue_style('style');
			wp_enqueue_style('dynamic', get_template_directory_uri() . '/css/dynamic.php');
			wp_enqueue_style('flip');
			wp_enqueue_style('animate');
			
			$GLOBALS['wp_styles']->add_data( 'ie8fixes', 'conditional', 'lte IE 8' );
			   wp_enqueue_style( 'ie8fixes' );
		}
	}
	add_action('wp_enqueue_scripts', 'curly_load_my_scripts');

/*	Enqueue Admin Scripts
    ================================================= */    	
	function curly_admin_enqueue($hook) {	
		wp_enqueue_script('jquery', '/wp-includes/js/jquery/jquery.js', 'json2', '', true); 
	    wp_enqueue_script('thickbox');
	    wp_enqueue_script('jquery-ui-accordion', 'jquery');
	 	wp_enqueue_style('thickbox');
	 	wp_enqueue_script('admin-js', get_template_directory_uri() . '/admin/js/admin.js', null, true);
	 	wp_enqueue_script('main', get_template_directory_uri() . '/admin/js/main.js', null, true);
	}
	add_action( 'admin_init', 'curly_admin_enqueue' );	
	
	function add_ie_html5_shim () {
	    echo '<!--[if lt IE 9]>';
	    echo '<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>';
	    echo '<script src="'.get_template_directory_uri() .'/js/respond.min.js"></script>';
	    echo '<![endif]-->';
	}
	add_action('wp_head', 'add_ie_html5_shim');

/*	Fix XUA
	================================================= */		
	function curly_fix_xua(){
		if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)) header('X-UA-Compatible: IE=edge,chrome=1');
	}
	add_action('send_headers', 'curly_fix_xua');	

/*	Custom Menu Walker (Subemnu Icon)
	================================================= */
	add_filter( 'wp_nav_menu_objects', 'add_menu_parent_class' );
	function add_menu_parent_class( $items ) {
		
		$parents = array();
		foreach ( $items as $item ) {
			if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
				$parents[] = $item->menu_item_parent;
			}
		}
		
		foreach ( $items as $item ) {
			if ( in_array( $item->ID, $parents ) ) {
				$item->classes[] = 'menu-parent-item'; 
			}
		}
		
		return $items;    
	}
	
/*	Register Theme Navigation
	================================================= */	
	register_nav_menus( array(
			'menuMainMenu' => 'Main Menu'
	));

/*	Register Sidebars
	================================================= */	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Sidebar - Blog', 'CURLYTHEME'),
		'id'			 => 'sidebar_blog',
		'before_widget'	 => '<div id="%1$s" class="sidebar-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Sidebar - Page' , 'CURLYTHEME'),
		'id'			 => 'sidebar_page',
		'before_widget'	 => '<div id="%1$s" class="sidebar-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h3>',
		'after_title'		 => '</h3>',
	));
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Pre-Footer Left' , 'CURLYTHEME'),
		'id'			 => 'pre_footer_sidebar_left',
		'before_widget'	 => '<div id="%1$s" class="col-lg-8 col-md-8 pre-footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h4 class="special-title"><span>',
		'after_title'		 => '</span></h4>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Pre-Footer Right' , 'CURLYTHEME'),
		'id'			 => 'pre_footer_sidebar_right',
		'before_widget'	 => '<div id="%1$s" class="col-lg-4 col-md-4 pre-footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h4 class="special-title"><span>',
		'after_title'		 => '</span></h4>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Footer Left Sidebar' , 'CURLYTHEME'),
		'id'			 => 'footer_sidebar_left',
		'before_widget'	 => '<div id="%1$s" class="col-lg-5 col-md-5 col-sm-4 footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Footer Center Sidebar' , 'CURLYTHEME'),
		'id'			 => 'footer_sidebar_center',
		'before_widget'	 => '<div id="%1$s" class="col-lg-4 col-md-4 col-sm-4 footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Footer Right Sidebar', 'CURLYTHEME'),
		'id'			 => 'footer_sidebar_right',
		'before_widget'	 => '<div id="%1$s" class="col-lg-3 col-md-3 col-sm-4 footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => 'Absolute Footer',
		'id'			 => 'absolute_footer',
		'before_widget'	 => '',
		'after_widget' 	 => '',
		'before_title'	 => '',
		'after_title'	 => '',
	));	

/*	Generate Fonts
	================================================= */
	function curly_generate_fonts(){
		
		$json_fonts_file = wp_remote_get( get_template_directory_uri(). "/admin/js/font-list.json");
		$json_fonts_data = json_decode($json_fonts_file['body'], true);

		// Fonts
		$fonts_body			=	get_option(THEMEPREFIX.'_fonts_body', 0);
		$fonts_h1			=	get_option(THEMEPREFIX.'_fonts_h1', 0);
		$fonts_h2			=	get_option(THEMEPREFIX.'_fonts_h2', 3);
		$fonts_h3			=	get_option(THEMEPREFIX.'_fonts_h3', 0);
		$fonts_h4			=	get_option(THEMEPREFIX.'_fonts_h4', 2);
		$fonts_h5			=	get_option(THEMEPREFIX.'_fonts_h5', 0);
		$fonts_h6			=	get_option(THEMEPREFIX.'_fonts_h6', 0);
		$fonts_menu			=	get_option(THEMEPREFIX.'_fonts_menu', 0);
		$fonts_blockquotes	=	get_option(THEMEPREFIX.'_fonts_blockquotes', 0);
		
		$fonts = array();

		array_push($fonts, $fonts_body);
		array_push($fonts, $fonts_h1);
		array_push($fonts, $fonts_h2);
		array_push($fonts, $fonts_h3);
		array_push($fonts, $fonts_h4);
		array_push($fonts, $fonts_h5);
		array_push($fonts, $fonts_h6);
		array_push($fonts, $fonts_menu);
		array_push($fonts, $fonts_blockquotes);
		
		$fonts = array_values(array_unique($fonts));
		
		for($i = 0; $i < count($fonts); $i++){
			if (isset($fonts[$i])) {
				if ($json_fonts_data[$fonts[$i]][0] == 1) {
					$fonts[$i] = str_replace(' ', '+' ,$json_fonts_data[$fonts[$i]][1]).':300,400,700';
				} else {
					$fonts[$i] = null;
				}
			}
		}
		$fonts	=	array_values(array_filter($fonts));
		
		$subset	=	get_option(THEMEPREFIX.'_fonts_subset',0);
		
		function subset_fonts($subset){
			switch ($subset){
				case 0 		: return 'latin'; break;
				case 1 		: return 'latin,cyrillic-ext,cyrillic'; break;
				case 2 		: return 'latin,greek-ext,greek'; break;
				case 3 		: return 'latin,greek'; break;
				case 4 		: return 'latin,vietnamese'; break;
				case 5 		: return 'latin,latin-ext'; break;
				case 5 		: return 'latin,cyrillic'; break;
			}
		}
		
		if (count($fonts) > 0) {
			$html =  " <script type=\"text/javascript\">\n
						WebFontConfig = {
					    google: { families: [";
			
						for($i=0; $i<count($fonts); $i++){
							$html .= "'".$fonts[$i].':'.subset_fonts($subset)."'";
							if($i < count($fonts)-1) { $html .= ','; }
						}		   
						 			    
			$html .= " ] }
					  };
					  (function() {
					    var wf = document.createElement('script');
					    wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
					      '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
					    wf.type = 'text/javascript';
					    wf.async = 'true';
					    var s = document.getElementsByTagName('script')[0];
					    s.parentNode.insertBefore(wf, s);
					})(); </script>";
			
			echo $html;
		}
	}
	add_action('wp_footer', 'curly_generate_fonts');

/*	Sanitize Font Names
	================================================= */
	function curly_font_names($font){
		return str_replace(' ', '+' ,$font);
	}

/*	Output Fonts
	================================================= */
	function curly_get_fonts() {
		$json_fonts_file = wp_remote_get( get_template_directory_uri(). "/admin/js/font-list.json");
		$json_fonts_data = json_decode($json_fonts_file['body'], true);
		
		$font_list = array();
		
		for ($i = 0; $i < count($json_fonts_data); $i++) {
			$font_list[$i] = $json_fonts_data[$i][1];
		}
		
		asort($font_list);
		
		return $font_list;
	}

/*	Generate Font Size Range
	================================================= */
	function curly_get_font_sizes($start, $stop){
		$sizes = array();
		for ($i=$start; $i<=$stop; $i++){ $sizes[$i] = $i.' px'; }
		return $sizes;
	}

/*	Generate Font Style
	================================================= */
	function curly_get_font_style($style){
		switch ($style) {
			case 0 : return 'font-weight: 300;';break;
			case 1 : return 'font-weight: 300;font-style: italic;';break;
			case 2 : return 'font-weight: normal;font-style: normal;';break;
			case 3 : return 'font-weight: 700;'; break;
			case 4 : return 'font-style: italic;';break;
			case 5 : return 'font-style: italic; font-weight: bold;';break;
		}
	}

/*	Generate Font Variant
	================================================= */
	function curly_get_font_variant($style){
		switch ($style) {
			case 0 : return null;break;
			case 1 : return 'text-transform: capitalize;';break;
			case 2 : return 'text-transform: uppercase;';break;
			case 3 : return 'font-variant: small-caps;';break;
		}
	}

/*	Allow Font Upload
	================================================= */	
	function curly_custom_mime_types($mimes)
	{
		$mimes['ttf'] = 'font/ttf';
		$mimes['woff'] = 'font/woff';
		$mimes['svg'] = 'font/svg';
		$mimes['eot'] = 'font/eot';
	
		return $mimes;
	}
	add_filter('upload_mimes', 'curly_custom_mime_types');

/*	Output Logo / Title
	================================================= */	
	function curly_get_logo(){
		$title 			= 	get_option(THEMEPREFIX.'_title', get_option('blogname'));
		$logo 			= 	get_option(THEMEPREFIX.'_logo');
		$logo_retina 	= 	get_option(THEMEPREFIX.'_logo_retina');
		$blog_title		= 	get_bloginfo('name');
		
		if($logo) { return '<div class="logo"><a href="'.home_url() .'" title="'.$blog_title.'"><img src="'.$logo.'" alt="'.$blog_title.'" class="logo-nonretina"><img src="'.$logo_retina.'" alt="'.$blog_title.'" class="logo-retina"></a></div>'; }
		else { return '<h1 class="logo"><a href="'.home_url().'" title="'.$blog_title.'">'.$title.'<small>'.get_bloginfo('description').'</small></a></h1>'; }
	}
	
/*	Generate Latest Tweets
	================================================= */	
	function curly_latest_tweets( $screen_name, $count, $rts, $ats ){
	    try {
	        if( ! function_exists('twitter_api_get') ){
	            require_once dirname(__FILE__).'/plugins/latest-tweets-widget/lib/twitter-api.php';
	            _twitter_api_init_l10n();
	        }
	        // We could cache the rendered HTML right here, but this keeps caching abstracted in library
	        twitter_api_enable_cache( 300 );
	        // Build API params for "statuses/user_timeline" // https://dev.twitter.com/docs/api/1.1/get/statuses/user_timeline
	        $trim_user = true;
	        $include_rts = ! empty($rts);
	        $exclude_replies = empty($ats);
	        $params = compact('count','exclude_replies','include_rts','trim_user','screen_name');
	        if( $exclude_replies || ! $include_rts ){
	            // Stripping tweets means we may get less than $count tweets.
	            // there is no good way around this other than fetch extra and hope for the best
	            $params['count'] *= 3;
	        }
	        $tweets = twitter_api_get('statuses/user_timeline', $params );
	        if( isset($tweets[$count]) ){
	            $tweets = array_slice( $tweets, 0, $count );
	        }
	        // render each tweet as a blocks of html for the widget list items
	        $rendered = array();
	        foreach( $tweets as $tweet ){
	            extract( $tweet );
	            $link = esc_html( 'http://twitter.com/'.$screen_name.'/status/'.$id_str);
	            // render nice datetime, unless theme overrides with filter
	            $date = apply_filters( 'latest_tweets_render_date', $created_at );
	            if( $date === $created_at ){
	                function_exists('twitter_api_relative_date') or twitter_api_include('utils');
	                $date = esc_html( twitter_api_relative_date($created_at) );
	                $date = '<span class="pull-right time"><i class="icon-time"></i> '.$date.'</span>';
	            }
	            // render and linkify tweet, unless theme overrides with filter
	            $html = apply_filters('latest_tweets_render_text', $text );
	            if( $html === $text ){
	                function_exists('twitter_api_html') or twitter_api_include('utils');
	                $html = twitter_api_html( $text );
	            }
	            // piece together the whole tweet, allowing overide
	            $final = apply_filters('latest_tweets_render_tweet', $html, $date, $link );
	            if( $final === $html ){
	                $final = '<p class="tweet-text">'.$html.
	                         '<a href="'.$link.'" target="_blank">'.$date.'</a>'.'</p>';
	            }
	            $rendered[] = $final;
	        }
	        return $rendered;
	    }
	    catch( Exception $Ex ){
	        return array( '<p class="tweet-text"><strong>Error:</strong> '.esc_html($Ex->getMessage()).'</p>' );
	    }
	}

/*	Generate Breadcrumbs
	================================================= */	
	function curly_breadcrumbs() {
		
		global $post;
		
		$active					=		get_option(THEMEPREFIX.'_bc', true);
		$strings_before			=		get_option(THEMEPREFIX.'_bc_text_before');
		$strings_home			=		get_option(THEMEPREFIX.'_bc_text_home', get_option('blogname'));
		$strings_category		=		get_option(THEMEPREFIX.'_bc_text_category', __("Archive by Category '%s'" , 'CURLYTHEME'));
		$strings_search			=		get_option(THEMEPREFIX.'_bc_text_search', __("Search Results for '%s'" , 'CURLYTHEME'));
		$strings_tag			=		get_option(THEMEPREFIX.'_bc_text_tag', __("Posts Tagged '%s'" , 'CURLYTHEME'));
		$strings_author			=		get_option(THEMEPREFIX.'_bc_text_author', __("Articles Posted by '%s'" , 'CURLYTHEME'));
		$strings_404			=		get_option(THEMEPREFIX.'_bc_text_404', __("Page not found" , 'CURLYTHEME'));
		$strings_separator		=		get_option(THEMEPREFIX.'_bc_separator', '&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;');
		
		if ($strings_before) $strings_before = '<li class="bc-before">'.$strings_before.'</li>';
		
		$home			 = home_url();
		$wrap_before	 = '<li>';
		$wrap_after 	 = '</li>';
		$link 			 = $wrap_before . '<a href="%1$s">%2$s</a>' . $strings_separator. $wrap_after;
		$html 			 = '<ul class="theme-bc">'.$strings_before. sprintf($link, $home, $strings_home);
	
		if ( is_page() && !$post->post_parent ) {
			$html .= $wrap_before.get_the_title().$wrap_after;
	
		} elseif ( is_page() && $post->post_parent ) {
			$parent_id  = $post->post_parent;
			$bc = array();
			while ($parent_id) {
				$page = get_page($parent_id);
				$bc[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
				$parent_id  = $page->post_parent;
			}
			$bc = array_reverse($bc);
			for ($i = 0; $i < count($bc); $i++) {
				$html .= $bc[$i];
			}
			$html .= $wrap_before.get_the_title().$wrap_after;
	
		} elseif (is_home()){
			$html .= $wrap_before.get_the_title(get_option('page_for_posts', true)).$wrap_after;
		} elseif ( is_category() ) {
			$thisCat = get_category(get_query_var('cat'), false);
			if ($thisCat->parent != 0) {
				$cats = get_category_parents($thisCat->parent, TRUE);
				$cats = str_replace('<a', $wrap_before . '<a' . $linkAttr, $cats);
				$cats = str_replace('</a>', '</a>'.$strings_separator.$wrap_after, $cats);
				$html .= $cats;
			}
			$html .= $wrap_before.sprintf($strings_category, single_cat_title('', false)).$wrap_after;
	
		} elseif ( is_search() ) {
			$html .= $wrap_before.sprintf($strings_search, get_search_query()).$wrap_after;
	
		} elseif ( is_day() ) {
			$html .= $wrap_before.sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')).$wrap_after;
			$html .= $wrap_before.sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')).$wrap_after;
			$html .= $wrap_before.get_the_time('d').$wrap_after;
	
		} elseif ( is_month() ) {
			$html .= $wrap_before.sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')).$wrap_after;
			$html .= $wrap_before.get_the_time('F').$wrap_after;
	
		} elseif ( is_year() ) {
			$html .= $wrap_before.get_the_time('Y').$wrap_after;
	
		} elseif ( is_single() && !is_attachment() ) {
				$html .= $wrap_before.get_the_title(get_option('page_for_posts')).$wrap_after;
		} elseif(is_tax()){
				
			$html .= $wrap_before.wp_title(' ', false).$wrap_after ;
			
		} elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
			$post_type = get_post_type_object(get_post_type());
			$html .= $wrap_before.$post_type->labels->singular_name.$wrap_after;
	
		} elseif ( is_attachment() ) {
			$html .= $wrap_before.wp_title(' ', false).$wrap_after ;
	
		} elseif ( is_tag() ) {
			$html .= $wrap_before.sprintf($strings_tag, single_tag_title('', false)).$wrap_after;
	
		} elseif ( is_author() ) {
			global $author;
			$userdata = get_userdata($author);
			$html .= $wrap_before.sprintf($strings_author, $userdata->display_name).$wrap_after;
	
		} elseif ( is_404() ) {
			$html .=  $wrap_before.$strings_404.$wrap_after;
		}
		
		
		function checkForPaged(){
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) return true;
		}
	
		if ( get_query_var('paged') ) if ( checkForPaged() == true) $html .= ' ('.__('Page') . ' ' . get_query_var('paged').')';
		
		$html .= '</ul>';
		
		return ($active == "true") ? $html : null;
	}

/*	Page Heading
	================================================= */
	function curly_get_page_title(){
		global $post;
		
		if (is_page() || is_single() || is_attachment() ) 
			if(get_post_type() == "post")
				return get_the_title(get_option('page_for_posts'));
			else
			return get_the_title();
		elseif	(is_home())
			return get_the_title(get_option('page_for_posts', true) );
		elseif (is_category() || is_tax())
			return single_cat_title('' , false);
		elseif (is_archive()){
			if ( is_day() ) :
				printf( __( 'Daily Archives: %s', 'CURLYTHEME' ), '<span>' . get_the_date() . '</span>' );
			elseif ( is_month() ) :
				printf( __( 'Monthly Archives: %s', 'CURLYTHEME' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'CURLYTHEME' ) ) . '</span>' );
			elseif ( is_year() ) :
				printf( __( 'Yearly Archives: %s', 'CURLYTHEME' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'CURLYTHEME' ) ) . '</span>' );
			else :
				_e( 'Archives', 'CURLYTHEME' );
			endif;
		}
		elseif (is_search())
			return __('Search Results' , 'CURLYTHEME');
		elseif (is_404())
			return __('Page not found' , 'CURLYTHEME');
		else
			return get_the_title();
	}
	
/*	SEO Page Titles
	=================================================*/
	function curly_get_page_seo_title(){
	
		global $post;
		
		$blog	= get_bloginfo('name');
		$desc	= get_bloginfo('description');
		
		if (is_single()) {
			
			$title  = get_post_meta($post->ID, 'seotitle', true);
			$format	= get_option(THEMEPREFIX.'_seo_title_post', 0);
			
			if(!$title) $title = $title = $post->post_title;
			
			switch($format){
				case '0'	: 	$title =  ucwords($title); break;
				case '1' 	: 	$title =  ucwords($title.' | '.$blog); break;
				case '2' 	: 	$title =  ucwords($title.' | '.$desc); break;
			}
			
		} elseif (is_page()) {
		
			$title  = get_post_meta($post->ID, 'seotitle', true);
			$format	= get_option(THEMEPREFIX.'_seo_title_page', 0);
			
			if(!$title) $title = $post->post_title;
			
			switch($format){
				case '0'	: 		$title = ucwords($title); break;
				case '1'	: 		$title = ucwords($title.' | '.$blog); break;
				case '2'	: 		$title = ucwords($title.' | '.$desc); break;
			}
		
		} elseif (is_category()) {
		
			$title  = single_cat_title('',false);
			$format	= get_option(THEMEPREFIX.'_seo_title_category', 1);
			$cate	= category_description();
			
			switch($format){
				case '1'	:  $title = ucwords($title.' | '.$blog); break;
				case '2'	:  $title = ucwords($title.' | '.$desc); break;
				case '3'   	:  $title = ucwords($title.' | '.strip_tags($cate)); break;
			}
		
		
		} elseif (is_tag()){
			
			$title  = single_tag_title('',false);
			$format	= get_option(THEMEPREFIX.'_seo_title_tag', 1);
			
			switch($format){
				case '1'   	  :  $title = ucwords($title.' | '.$blog); break;
				case '2'	  :  $title = ucwords($title.' | '.$desc); break;
			}
		
		} elseif (is_search()){
			
			global $query_string;
			$title  = substr(strip_tags($query_string), 2);
			$format	= get_option(THEMEPREFIX.'_seo_title_search', 1);
			
			switch($format){
				case '1'   	   :  $title = ucwords($title.' | '.$blog); break;
				case '2'	   :  $title = ucwords($title.' | '.$desc); break;
			}
			
		}elseif (is_archive()){
			
			$title  = single_month_title('',false);
			$format	= get_option(THEMEPREFIX.'_seo_title_archive', 1);
			
			switch($format){
				case '1'   	   :  $title = ucwords($title.' | '.$blog); break;
				case '2'	   :  $title = ucwords($title.' | '.$desc); break;
			}
		
		} elseif (is_404()){
			$title	= ucwords(get_option(THEMEPREFIX.'_seo_title_search', __('404 Error. Page Not Found.', 'CURLYTHEME')));
		} elseif (is_home()){
			$title	= ucwords(get_the_title(get_option('page_for_posts')).' | '.$blog);
		}
		
		return $title;
	}
	
	if( get_option(THEMEPREFIX.'_seo') != "true" && get_option(THEMEPREFIX.'_seo_title_rewrite') != 'true') { 
		add_filter( 'wp_title', 'curly_get_page_seo_title', 10, 2 );
	}

/*	Add Shortcodes Buttons to TinyMCE
	================================================= */
	add_action('init', 'curly_add_button');
	add_action('init', 'curly_add_button2');

	function curly_add_button() {  
	   if ( current_user_can('edit_posts') &&  current_user_can('edit_pages') )  
	   {  
	     add_filter('mce_external_plugins', 'curly_add_plugin');  
	     add_filter('mce_buttons_3', 'curly_register_button');  
	   }  
	}  
	
	function curly_add_button2() {  
	   if ( current_user_can('edit_posts') &&  current_user_can('edit_pages') )  
	   {  
	     add_filter('mce_external_plugins', 'curly_add_plugin2');  
	     add_filter('mce_buttons_4', 'curly_register_button2');  
	   }  
	}  
	
	function curly_register_button($buttons) {  
	   array_push($buttons, "column_12", "column_13", "column_23", "column_14", "column_24", "column_34", "clear", "divider",  "button", "alert", "blockquotee", "lists", "abbrr", "dropcap", "highlight", "action", "accordion", "tabs ");  
	   return $buttons;  
	}  
	
	function curly_register_button2($buttons) {  
	   array_push($buttons, "person","testimonials", "youtube", "vimeo", "toggle" ,"slider"  ,"marker", "boxes", "progress", "pricing", "icon", "clients",  "lightbox", "lightbox", "photoframe",  "picturezoom", "agenda"); 
	   return $buttons;  
	}  

	function curly_add_plugin($plugin_array) {  
	   $plugin_array['column_12']	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['column_13']	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['column_23']	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['column_14'] 	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['column_24'] 	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['column_34'] 	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['divider']   	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['button']   	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['alert']   	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['blockquotee']  = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['lists']  		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['abbrr']  		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['dropcap']  	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['highlight']  	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['action']  	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['accordion'] 	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['tabs'] 		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	
	   return $plugin_array;  
	}
	
	function curly_add_plugin2($plugin_array) {  
	   $plugin_array['person']  	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['testimonials'] = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['youtube'] 	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['vimeo']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['toggle']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['slider']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['marker']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['boxes']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['progress']	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['pricing']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['clear']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['icon']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['clients']		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['lightbox']	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['photoframe']	 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['picturezoom']  = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   $plugin_array['agenda'] 		 = get_template_directory_uri().'/shortcodes/tinymce/buttons.js';
	   
	   return $plugin_array;  
	}

/*	Shortcode Sanitizer
	================================================= */
	function curly_shortcode_sanitizer($content) {
		$needle = join("|",array("column", '\/column', "list", "tabs", "tab", "toggle", "accordion", "testimonials", "testimonial", "clear", "divider", "button", "blockquote", "highlight", "call2action", "toggle-box", "slider", "slide", "youtube", "vimeo", "progress", "icon", "clients", "client", "pretty-photo", "agenda", "event-day", "event", "pricing-table", "pricing-column", "pricing-header", "pricing-row", "pricing-footer", "map-maker", "picture-zoom", "full-width-box", '\/full-width-box', "box", "\/box", "ios-slider", "ios-slide", "roundabout-slider", "roundabout-slide", "person", "photo-frame", "gallery"));
	
		$html = preg_replace("/(<p>)?\[($needle)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);
		$html = preg_replace("/(<p>)?\[\/($needle)](<\/p>|<br \/>)/","[/$2]",$html);
	
		return $html;
	}
	add_filter('the_content', 'curly_shortcode_sanitizer');
	add_filter('widget_text', 'curly_shortcode_sanitizer');

/*	Generate Slider
	================================================= */
	function curly_get_slider(){
		global $post;
		
		// Slider
		$slider		 			 = get_post_meta($post->ID, 'slider', true);
		$display   	 			 = get_post_meta($post->ID, 'display', true);
		$height  	 			 = get_post_meta($post->ID, 'height', true);
		$slider_text_color   	 = get_post_meta($post->ID, 'slider_text_color', true);
		$slider_color   	 	 = get_post_meta($post->ID, 'slider_color', true);
		$slider_shortcode   	 = get_post_meta($post->ID, 'slider_shortcode', true);
		
		// Slides
		$links  	 	= get_post_meta($post->ID, 'slides_link', true);
		$images  	 	= get_post_meta($post->ID, 'slides_images', true);
		$titles  	 	= get_post_meta($post->ID, 'slides_title', true);
		$subtitles   	= get_post_meta($post->ID, 'slides_subtitle', true);
		$descriptions	= get_post_meta($post->ID, 'slides_description', true);
		$buttons		= get_post_meta($post->ID, 'slides_buttons', true);
		$buttons_texts  = get_post_meta($post->ID, 'slides_buttons_texts', true);
		
		$settings = null;
		
		if($display == 'off') $css_display = ' boxed_small';
		
		if($slider != 'no-slider'){
			
			// iOS Slider
			if($slider == 'ios-slider'){
				if($slider_text_color != "#") $settings .= ' textcolor="'.$slider_text_color.'"';
				if($slider_text_color != "#") $settings .= ' bgcolor="'.$slider_color.'"';
				if($height == "on") $settings .= ' height="tall"';
				$out = '[ios-slider'.$settings.']';
				for($i=0; $i<count($links); $i++) {
					$out .= '[ios-slide title="'.$titles[$i].'" subtitle="'.$subtitles[$i].'"  link="'.$links[$i].'"  textcolor="'.$slider_text_color.'" bgcolor="'.$slider_color.'" image="'.wp_get_attachment_url($images[$i]).'"][/ios-slide]';
				}
				$out .= '[/ios-slider]';
				
				if($display == "off"){ $before = null; $after = null;}
				echo $before.do_shortcode($out).$after;
			}
			
			// Round About Slider
			elseif($slider == 'roundabout-slider'){
				if($slider_text_color != "#") $settings .= ' textcolor="'.$slider_text_color.'"';
				if($slider_text_color != "#") $settings .= ' bgcolor="'.$slider_color.'"';
				if($height == "on") $settings .= ' height="tall"';
				$out = '[roundabout-slider'.$settings.']';
				for($i=0; $i<count($links); $i++) {
					$out .= '[roundabout-slide image="'.wp_get_attachment_url($images[$i]).'"  title="'.$titles[$i].'" link="'.$links[$i].'"][/roundabout-slide]';
				}
				$out .= '[/roundabout-slider]';
				
				$before = null; $after = null;
				echo $before.do_shortcode($out).$after;
			}
			
			// Layer Slider
			elseif($slider == 'layer-slider'){
				$out = $slider_shortcode;
				if($display == "off"){ $before = '<div class="layer-slider-container">'; $after = '</div>';}
				echo $before.do_shortcode($out).$after;
			}
		}
	}
	
/*	Header Hook
    ================================================= */ 
	function curly_header_css(){
		
		$html = '<style type="text/css" media="all">'."\n";
		
		$header_img = null;
		
		if (is_page() || is_single()) {
		
			global $post;
			
			$header_img 	= get_post_meta($post->ID, THEMEPREFIX.'page_settings_heading_image', true);
			$header_large 	= get_post_meta($post->ID, THEMEPREFIX.'large_header', true);
			
			$slider		 		= 	get_post_meta($post->ID, 'slider', true);
			
			if($slider != 'no-slider' && $slider != null && $slider != 'roundabout-slider' && $slider != 'vertical-slider'){
			
				// Slider Settings
				$display_size   	 	= 	get_post_meta($post->ID, 'display', true);
				$slider_text_color   	= 	get_post_meta($post->ID, 'slider_text_color', true);
				$slider_color   	 	= 	get_post_meta($post->ID, 'slider_color', true);
				$display				= 	get_post_meta($post->ID, 'height', true);
				
				$html .= '.page-heading{ display:none }';
				
				if($slider == 'ios-slider'){
						if($display_size == "on") $html .= '.wrapper-header:after{display:block}';	
						// Titles Color
						if($slider_text_color) 
							$html .= '.text1 h3, .text2 h4 { 
										color: '.$slider_text_color.' !important;
										border-left: 5px solid '.$slider_text_color.';
									 }
									 .text1 h3 a, .text2 h4 a{
									 	color: '.$slider_text_color.' !important;
									 }
									 .text1, .text2{
									 	background: rgba( '.hexToRgb($slider_color).', .85);
									 }
									 html.ie7 .text1, html.ie7 .text2,
									 html.ie8 .text1, html.ie8 .text2{
									 	background: '.$slider_color.';
									 }';
				}
			}
			
			if($slider == 'layer-slider'){
				$html .= '#header{ position:absolute; background: transparent !important }';
			}
		}
		
		if(isset($header_large) && $header_img != null && $header_large == true){
			$img_id = curly_get_attachment_id_by_src($header_img);
			$img_height = wp_get_attachment_image_src($img_id, 'full');
			$html .= '.page-heading{ display:none }';
			$html .= '#header{ min-height:'.$img_height[2].'px; background-size: cover!important}';
		}
       
		if(is_page_template('page-templates/contact.php') && get_option(THEMEPREFIX.'_general_email') != null){
			$html .= '.page-heading { display:none } #header{ background-position: center center !important}';
		}
		
		if(is_page_template('page-templates/-coming-soon.php') && $header_img != null){
			$html .= 'body { background: url('.$header_img.') no-repeat top center; background-attachement: fixed; background-size: cover ; }';
		}
		
		if (!$header_img) $header_img = get_header_image();
		
		$html .= '#header { background: url('.$header_img.') no-repeat top center; background-size: cover }';
		
		$html .= '</style>';
		echo $html;
       
    }
    add_action('wp_head','curly_header_css');

/*	Get Attachement ID
	================================================= */
	function curly_get_attachment_id_by_src($image_src) {
	
	    global $wpdb;
	    $query = "SELECT ID FROM {$wpdb->posts} WHERE guid='$image_src'";
	    $id = $wpdb->get_var($query);
	    return $id;
	
	}    

/*	Convert HEX Color Code to RGB Color Code
	================================================= */
	function hexToRgb($hex) {
	   $hex = str_replace("#", "", $hex);
	
	   if(strlen($hex) == 3) {
	      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
	      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
	      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
	      $r = hexdec(substr($hex,0,2));
	      $g = hexdec(substr($hex,2,2));
	      $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = array($r, $g, $b);
	   return implode(",", $rgb);
	}

/*	Custom Pagination
	================================================= */
	function curly_get_pagination($pages = null){
		global $wp_query;
		global $paged;
		
		if($pages ==  null) $pages = $wp_query->max_num_pages;
		
		if($paged == 0) $paged++;
		if($pages > 1)
		{
		   $html = '<ul class="pagination">';
		   if($paged > 1) $html .= '<li><a class="pagination-prev" href="'.get_pagenum_link($paged - 1).'"><span>'.__('&laquo;', 'CURLYTHEME').'</span></a></li>';
		   for ($i=1; $i <= $pages; $i++){
			  $html .= ($paged == $i) ? '<li class="active"><span>'.$i.'</span></li>' : '<li><a href="'.get_pagenum_link($i).'" class="inactive">'.$i.'</a></li>';
		   }
		   if ($paged < $pages) $html .= '<li><a class="pagination-next" href="'.get_pagenum_link($paged + 1).'">'.__('&raquo;', 'CURLYTHEME').'</a></li>';  
		   $html .= '</ul>';
		   return $html;
	     }
		 else return null;
	}

/*	Get Comments
	================================================= */
	function comments( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
		?>
		<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
			<p><?php _e( 'Pingback:', 'CURLYTHEME' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'CURLYTHEME'), '<span class="edit-link">', '</span>' ); ?></p>
		<?php
				break;
			default :
			// Proceed with normal comments.
			global $post;
		?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
			<article id="comment-<?php comment_ID(); ?>" class="comment">
				<header class="comment-meta comment-author vcard">
					<?php
						echo get_avatar( $comment, 40 );
						printf( '<cite class="fn">%1$s </cite>',
								get_comment_author_link()
						);
						printf( '<time datetime="%1$s">@ %2$s</time>',
								get_comment_time( 'c' ),
								sprintf( __( '%1$s at %2$s', 'CURLYTHEME' ), get_comment_date(), get_comment_time() )
						);
					?>
				</header><!-- .comment-meta -->
	
				<section class="comment-content comment">
					<div>
						<?php comment_text(); ?>
					</div>
					<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply <i class="icon-share-alt"></i>', 'CURLYTHEME' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
					<?php edit_comment_link( __( 'Edit', 'CURLYTHEME' ), '<span class="edit-link">', '</span>' ); ?>
					<?php if ( '0' == $comment->comment_approved ) : ?>
						<span class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'CURLYTHEME' ); ?></span>
					<?php endif; ?>
				</section>
			</article>
		<?php
			break;
		endswitch; 
	}

/*	Custom Excerpt
	================================================= */
	function curly_custom_excerpt_length() {
		$length					=	get_option(THEMEPREFIX.'_blog_listing_excerpt');
		if (!$length) $length = 60;
		return $length;
	}
	add_filter( 'excerpt_length', 'curly_custom_excerpt_length', 999 );

/*	Sanitize Category Links
	================================================= */
	function curly_remove_category_list_rel( $output ) {
	    return str_replace( ' rel="category tag"', '', $output );
	}
	add_filter( 'wp_list_categories', 'curly_remove_category_list_rel' );
	add_filter( 'the_category', 'curly_remove_category_list_rel' );

/*	Enqueue Comments Reply
	================================================= */
	function curly_xtreme_enqueue_comments_reply() {
	    if( get_option( 'thread_comments' ) )  {
	        wp_enqueue_script( 'comment-reply' );
	    }
	}
	add_action( 'comment_form_before', 'curly_xtreme_enqueue_comments_reply' );

/*	Check for Shortcodes
	================================================= */
	function curly_has_shortcode($shortcode = '') {
		$post_to_check = get_post(get_the_ID());
		$found = false;
		if (!$shortcode) {
			return $found;
		}
		if ( stripos($post_to_check->post_content, '[' . $shortcode) !== false ) {
			$found = true;
		}
		return $found;
	}
	
/*	Language Switcher
	================================================= */
	function curly_language_selector_flags(){
		if(function_exists('icl_get_languages')){
			$html = '<div class="curly-lang-switcher"><i class="icon-globe"></i>  '.get_option(THEMEPREFIX.'_header_2nd_text_line' , __('Choose Language' , 'CURLYTHEME')).'<ul>';
		    $languages = icl_get_languages('skip_missing=0&orderby=code');
		    if(!empty($languages)){
		        foreach($languages as $l){
		        	$html .= '<li>';
		            if(!$l['active']) $html .= '<a href="'.$l['url'].'">';
		            $html .= '<i class=" icon-angle-right"></i> '.$l['native_name'];
		            if(!$l['active']) $html .= '</a>';
		            $html .= '</li>';
		        }
		    }
		    $html .= '</ul></div>';
	    }
	    
	   return (isset($html)) ? $html : null;
	}

/*	3rd Party Integration
	================================================= */

/*	WPML
	================================================= */
	define('ICL_DONT_LOAD_NAVIGATION_CSS', true);
	define('ICL_DONT_LOAD_LANGUAGE_SELECTOR_CSS', true);
	define('ICL_DONT_LOAD_LANGUAGES_JS', true);

/*
	WooCommerce
	================================================= */
	add_theme_support( 'woocommerce' );
	
	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	
		/* Register WooCommerce Sidebar */
	    if ( function_exists('register_sidebar'))
	    	register_sidebar(array(
	    	'name'			 => 'Sidebar - Shop',
	    	'id'				 => 'sidebar_shop',
	    	'before_widget'	 => '<div id="%1$s" class="sidebar_widget %2$s">',
	    	'after_widget' 	 => '</div>',
	    	'before_title'	 => '<h5 class="special-title"><span>',
	    	'after_title'		 => '</span></h5>',
	    ));
	    
	    /* Breadcrumbs */
	    remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);
	    
	    function curly_woocommerce_breadcrumbs() {
	    	$before = (get_option(THEMEPREFIX.'_bc_text_before')) ? '<li>'.get_option(THEMEPREFIX.'_bc_text_before').'</li>' : null;
	        return array(
	                'delimiter'   => get_option(THEMEPREFIX.'_bc_separator', '&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;'),
	                'wrap_before' => '<ul class="theme-bc" itemprop="breadcrumb">'.$before,
	                'wrap_after'  => '</ul>',
	                'before'      => '<li>',
	                'after'       => '</li>',
	                'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
	            );
	    }
	    
	    add_filter( 'woocommerce_breadcrumb_defaults', 'curly_woocommerce_breadcrumbs' );
	    
	    /* Pagination */
   		remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);
   		function woocommerce_pagination() {
   		    echo curly_get_pagination();      
   		}
   		add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10);
	}	
?>